import java.awt.Cursor;

import javax.swing.JFrame;

public class CursorManager
{
	private static JFrame Window = null; // the window for which the cursor is to be updated
	private static boolean WaitCursorEnabled = false; // priority: before crosshair cursor
	private static boolean CrosshairCursorEnabled = false; // priority: before default (normal) cursor

	private static Cursor SelectCursor()
	{
		if (WaitCursorEnabled)
			return new Cursor(Cursor.WAIT_CURSOR);
		else if (CrosshairCursorEnabled)
			return new Cursor(Cursor.CROSSHAIR_CURSOR);
		else
			return new Cursor(Cursor.DEFAULT_CURSOR);
	}

	public static void SetCrosshairCursorEnabled(boolean CrosshairCursorEnabledNew)
	{
		CrosshairCursorEnabled = CrosshairCursorEnabledNew;

		UpdateCursor();
	}

	public static void SetWaitCursorEnabled(boolean WaitCursorEnabledNew)
	{
		WaitCursorEnabled = WaitCursorEnabledNew;

		UpdateCursor();
	}

	public static void SetWindow(JFrame WindowNew)
	{
		Window = WindowNew;
	}

	private static void UpdateCursor()
	{
		Cursor SelectedCursor = SelectCursor();

		if (Window.getCursor() != SelectedCursor)
		{
			Window.setCursor(SelectedCursor);
		}
	}
}
